﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Business;
using DataAccess;

namespace Presentation
{
    public partial class WandelroutesFilter2Form : Form
    {
        private WandelrouteDA _wandelrouteDA;
        private List<Wandelroute> _wandelroutesLijst;

        public WandelroutesFilter2Form()
        {
            InitializeComponent();

            // het veld _wandelrouteDA initialiseren
            _wandelrouteDA = new WandelrouteDA();

            // het veld met de lijst initialiseren
            _wandelroutesLijst = new List<Wandelroute>();
        }

        private void filterButton_Click(object sender, EventArgs e)
        {
            int min = 0;      // hulpvariabele min initialiseren op de minimumafstand 0
            int max = 999999; // hulpvariabele max initialiseren op een (zeer grote) maximumafstand
            
            // min-afstand uit tekstvak halen (indien tekstvak niet leeg is)
            if (minKmTextBox.Text != "")
            {
                min = Convert.ToInt32(minKmTextBox.Text);
            }

            // max-afstand uit tekstvak halen (indien tekstvak niet leeg is)
            if (maxKmTextBox.Text != "")
            {
                max = Convert.ToInt32(maxKmTextBox.Text);
            }

            // de lijst op basis van filter opvullen via ons data-accessobject 
            _wandelroutesLijst = _wandelrouteDA.ReadTableFilterRangeAfstand(min,max);

            // de lijst met wandelroutes vernieuwen in de listbox
            wandelroutesListBox.DataSource = null;
            wandelroutesListBox.DataSource = _wandelroutesLijst;
        }
    }
}
