﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using Business;
using DataAccess;

namespace Presentation
{
    public partial class ActiviteitenForm : Form
    {

        private ActiviteitDA _activiteitDA;
        private List<Activiteit> _activiteitenLijst;

        public ActiviteitenForm()     
        {
            InitializeComponent();

            // het veld _activiteitenLijst initialiseren
            _activiteitenLijst = new List<Activiteit>();

            // het data-accessobject _activiteitDA initialiseren
            _activiteitDA = new ActiviteitDA();

            // de lijst met activiteiten opvullen via ons data-accessobject
            _activiteitenLijst = _activiteitDA.ReadTable();

            // de lijst met activiteiten weergeven in de listbox
            activiteitenListBox.DataSource = _activiteitenLijst;
        }

        private void sorteerAlfabetischButton_Click(object sender, EventArgs e)
        {
            // de lijst met activiteiten opvullen via ons data-accessobject
            //   activiteiten staan alfabetisch gesorteerd op beschrijving
            _activiteitenLijst = _activiteitDA.ReadTable();

            // de lijst met activiteiten weergeven in de listbox
            activiteitenListBox.DataSource = null;
            activiteitenListBox.DataSource = _activiteitenLijst;
        }

        private void sorteerChronologischButton_Click(object sender, EventArgs e)
        {
            // de lijst met activiteiten opvullen via ons data-accessobject
            //   activiteiten staan (omgekeerd) chronologisch gesorteerd op datumtijd
            _activiteitenLijst = _activiteitDA.ReadTableSortDatumTijd();

            // de lijst met activiteiten weergeven in de listbox
            activiteitenListBox.DataSource = null;
            activiteitenListBox.DataSource = _activiteitenLijst;
        }
    }
}
