﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using MySql.Data.MySqlClient;
using Business;

namespace DataAccess
{
    public class ActiviteitDA
    {
        private string _connString;
        private MySqlConnection _mySqlConnection;

        public ActiviteitDA()
        {
            // connectiestring voor de MySQL-databank mijnjeugdbeweging
            _connString = "server=localhost;user id=root;password=Leerling123;database=mijnjeugdbeweging";

            // de connectie in tekstformaat omzetten naar een MySqlConnection
            _mySqlConnection = new MySqlConnection(_connString);
        }

        public List<Activiteit> ReadTable()
        {
            // een List voor Activiteit-object declareren en initialiseren
            List<Activiteit> lijst = new List<Activiteit>();

            // SQL-statement om alle activiteiten, alfabetisch gerangschikt, op te vragen 
            String sql = "SELECT * FROM activiteiten ORDER BY beschrijving";

            // SQL-commando aanmaken op basis van ons SQL-statement
            MySqlCommand mySqlCommand = new MySqlCommand(sql, _mySqlConnection);

            // de connectie met de databank openen
            _mySqlConnection.Open();

            // met ExecuteReader laat je een leescommando opstarten
            //   ingelezen informatie komt in mySqlDataReader terecht
            MySqlDataReader mySqlDataReader = mySqlCommand.ExecuteReader();

            // lusje om alle records in mySqlDataReader te overlopen
            while (mySqlDataReader.Read() == true)
            {
                // nieuwe wandelroute maken met de actieve record in mySqlDataReader
                Activiteit activiteit = new Activiteit((int) mySqlDataReader["activiteitID"], mySqlDataReader["beschrijving"].ToString(), (DateTime) mySqlDataReader["datumTijd"]);

                // voeg de activiteit toe aan de lijst
                lijst.Add(activiteit);
            }

            // de connectie met de databank terug sluiten
            _mySqlConnection.Close();

            // lijst met alle activiteiten teruggeven
            return lijst;
        }

        public List<Activiteit> ReadTableSortDatumTijd()
        {
            // een List voor Activiteit-object declareren en initialiseren
            List<Activiteit> lijst = new List<Activiteit>();

            // SQL-statement om alle activiteiten, (omgekeerd) chronologisch, op te vragen 
            String sql = "SELECT * FROM activiteiten ORDER BY datumtijd DESC";

            // SQL-commando aanmaken op basis van ons SQL-statement
            MySqlCommand mySqlCommand = new MySqlCommand(sql, _mySqlConnection);

            // de connectie met de databank openen
            _mySqlConnection.Open();

            // met ExecuteReader laat je een leescommando opstarten
            //   ingelezen informatie komt in mySqlDataReader terecht
            MySqlDataReader mySqlDataReader = mySqlCommand.ExecuteReader();

            // lusje om alle records in mySqlDataReader te overlopen
            while (mySqlDataReader.Read() == true)
            {
                // nieuwe wandelroute maken met de actieve record in mySqlDataReader
                Activiteit activiteit = new Activiteit((int)mySqlDataReader["activiteitID"], mySqlDataReader["beschrijving"].ToString(), ((DateTime)mySqlDataReader["datumTijd"]));

                // voeg de activiteit toe aan de lijst
                lijst.Add(activiteit);
            }

            // de connectie met de databank terug sluiten
            _mySqlConnection.Close();

            // lijst met alle activiteiten teruggeven
            return lijst;
        }

        public void CreateRecord(Activiteit activiteit)
        {
            // SQL-statement om een activiteit toe te voegen 
            String sql = "INSERT INTO activiteiten(beschrijving, datumtijd) VALUES(@Beschrijving, @DatumTijd);";

            // SQL-commando aanmaken op basis van ons SQL-statement
            MySqlCommand mySqlCommand = new MySqlCommand(sql, _mySqlConnection);

            // parameters in het SQL-commando hun waarde geven
            mySqlCommand.Parameters.AddWithValue("@Beschrijving", activiteit.Beschrijving);
            mySqlCommand.Parameters.AddWithValue("@DatumTijd", activiteit.DatumTijd);

            // de connectie met de databank openen
            _mySqlConnection.Open();

            // ExecuteNonQuery om een MySqlCommand te starten dat geen gegevens inleest
            mySqlCommand.ExecuteNonQuery();

            // de connectie met de databank terug sluiten
            _mySqlConnection.Close();
        }
    }
}
