﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Business;

namespace Presentation
{
    public partial class CocktailInfoForm : Form
    {
        private Cocktail _cocktail;

        public CocktailInfoForm(Cocktail cocktail)
        {
            InitializeComponent();

            _cocktail = cocktail;

            naamTextBox.Text = _cocktail.Naam;
            kostprijsTextBox.Text = _cocktail.Kostprijs.ToString("C");
            inhoudTextBox.Text = _cocktail.InhoudCocktail().ToString();
            alcoholpercentageTextBox.Text = _cocktail.Alcoholpercentage().ToString("P0");

            alcIngredientenListBox.DataSource = _cocktail.AlcoholischeIngredienten();
            nonalcIngredientenListBox.DataSource = _cocktail.NietAlcoholischeIngredienten();
        }
        
        private void alcToonButton_Click(object sender, EventArgs e)
        {
            Ingredient ingredient = (Ingredient)alcIngredientenListBox.SelectedItem;

            IngredientForm formulier = new IngredientForm(ingredient);
            formulier.Show();
        }

        private void nonalcToonButton_Click(object sender, EventArgs e)
        {
            Ingredient ingredient = (Ingredient)nonalcIngredientenListBox.SelectedItem;

            IngredientForm formulier = new IngredientForm(ingredient);
            formulier.Show();
        }

        private void pittigerButton_Click(object sender, EventArgs e)
        {
            _cocktail.MaakPittiger();

            inhoudTextBox.Text = _cocktail.InhoudCocktail().ToString();
            alcoholpercentageTextBox.Text = _cocktail.Alcoholpercentage().ToString("P0");

            alcIngredientenListBox.DataSource = null;
            alcIngredientenListBox.DataSource = _cocktail.AlcoholischeIngredienten();
            nonalcIngredientenListBox.DataSource = null;
            nonalcIngredientenListBox.DataSource = _cocktail.NietAlcoholischeIngredienten();
        }


    }
}
