﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Reisbureau
{
    public class Groepsreis
    {
        private String _bestemming;
        private int _maxDeelnemers;
        private int _inschrijvingen;
        private double _prijsPerPersoon;
        private bool _kinderenToegelaten;
        private char _klasseVerblijf;

        public Groepsreis(String bestemming, int maxDeelnemers, double prijsPerPersoon)
        {
            _bestemming = bestemming;
            _maxDeelnemers = maxDeelnemers;
            _inschrijvingen = 1;
            _prijsPerPersoon = prijsPerPersoon;
            _kinderenToegelaten = true;
            _klasseVerblijf = 'B';
        }

        public String GetBestemming()
        {
            return _bestemming;
        }

        public int GetMaxDeelnemers()
        {
            return _maxDeelnemers;
        }

        public int GetInschrijvingen()
        {
            return _inschrijvingen;
        }

        public double GetPrijsPerPersoon()
        {
            return _prijsPerPersoon;
        }

        public bool GetKinderenToegelaten()
        {
            return _kinderenToegelaten;
        }
        
        public char GetKlasseVerblijf()
        {
            return _klasseVerblijf;
        }

        public void SetPrijsPerPersoon(double prijsPerPersoon)
        {
            _prijsPerPersoon = prijsPerPersoon;
        }
        
        public void SetKinderenToegelaten(bool kinderenToegelaten)
        {
            _kinderenToegelaten = kinderenToegelaten;
        }

        public void SetKlasseVerblijf(char klasseVerblijf)
        {
            _klasseVerblijf = klasseVerblijf;
        }

        public void VolwasseneInschrijven()
        {
            if (_inschrijvingen < _maxDeelnemers)
            {
                _inschrijvingen++;
            }
        }

        public void KinderenInschrijven(int aantalKinderen)
        {
            if (_kinderenToegelaten == true && _inschrijvingen + aantalKinderen <= _maxDeelnemers)
            {
                _inschrijvingen += aantalKinderen;
            }
        }
    }
}
